% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_result_collection.R
\name{hyperparameter}
\alias{hyperparameter}
\alias{hyperparameter,musica-method}
\alias{hyperparameter,result_collection-method}
\alias{hyperparameter<-}
\alias{hyperparameter<-,musica,list-method}
\alias{hyperparameter<-,result_collection,list-method}
\title{Retrieve hyperparameter from a musica or result_collection object}
\usage{
hyperparameter(x, ...)

\S4method{hyperparameter}{musica}(x, result)

\S4method{hyperparameter}{result_collection}(x)

hyperparameter(x, ...) <- value

\S4method{hyperparameter}{musica,list}(x, result) <- value

\S4method{hyperparameter}{result_collection,list}(x) <- value
}
\arguments{
\item{x}{A \code{\linkS4class{result_model}} or
\code{\linkS4class{result_collection}} object}

\item{...}{Other inputs}

\item{result}{The name of the result_list entry.}

\item{value}{A \code{\linkS4class{list}} of hyperparameters for model}
}
\value{
A list of hyperparameters
}
\description{
The \code{hyperparameter} contain list of prior and tuning
parameters
}
\examples{
data(res)
hyperparameter(res, "result")
}
