% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_result_collection.R
\name{get_modality}
\alias{get_modality}
\alias{get_modality,musica-method}
\alias{get_modality,result_collection-method}
\title{Retrieve a specific modality entry from a musica or result_collection
object}
\usage{
get_modality(x, ...)

\S4method{get_modality}{musica}(x, result, modality)

\S4method{get_modality}{result_collection}(x, modality)
}
\arguments{
\item{x}{A \code{\linkS4class{result_model}} or
\code{\linkS4class{result_collection}} object}

\item{...}{Other inputs}

\item{result}{The name of the result_list entry.}

\item{modality}{The modality.}
}
\value{
A list of modality which contains result_model objects
}
\description{
\code{modality} list contains model results for a modality
}
\examples{
data(res)
get_modality(res, "result", "SBS96")
}
