% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umap.R
\name{create_umap}
\alias{create_umap}
\title{Create a UMAP from a model result}
\usage{
create_umap(
  musica,
  model_name,
  modality = "SBS96",
  result_name = "result",
  n_neighbors = 30,
  min_dist = 0.75,
  spread = 1
)
}
\arguments{
\item{musica}{A \code{\linkS4class{musica}} object containing a mutational
signature discovery or prediction.}

\item{model_name}{The name of the desired model.}

\item{modality}{The modality of the model. Must be "SBS96", "DBS78", or
"IND83". Default \code{"SBS96"}.}

\item{result_name}{Name of the result list entry containing the model.
Default \code{"result"}.}

\item{n_neighbors}{The size of local neighborhood used for views of
manifold approximation. Larger values result in more global the manifold,
while smaller values result in more local data being preserved.
If \code{n_neighbors} is larger than the number of samples,
then \code{n_neighbors} will automatically be set to the number of samples
in the \code{\linkS4class{musica}}. Default \code{30}.}

\item{min_dist}{The effective minimum distance between embedded points.
Smaller values will result in a more clustered/clumped embedding where
nearby points on the manifold are drawn closer together, while larger
values will result on a more even dispersal of points. Default \code{0.2}.}

\item{spread}{The effective scale of embedded points. In combination with
‘min_dist’, this determines how clustered/clumped the embedded points are.
Default \code{1}.}
}
\value{
A \code{\linkS4class{musica}} object with a new UMAP
stored in the \code{UMAP} slot of the \code{\linkS4class{result_model}}
object for the model.
}
\description{
Proportional sample exposures will be used as input into the
\code{\link[uwot]{umap}} function to generate a two dimensional UMAP.
}
\examples{
data(res_annot)
create_umap(res_annot, model_name = "res_annot")
}
\seealso{
See \link{plot_umap} to display the UMAP and
\code{\link[uwot]{umap}} for more information on the individual parameters
for generating UMAPs.
}
