% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discovery_prediction.R
\name{combine_predict_grid}
\alias{combine_predict_grid}
\title{Combine signatures and exposures of different models. Exposure values are
zero for samples in an annotation where that signature was not predicted}
\usage{
combine_predict_grid(
  musica,
  modality,
  signature_res,
  model_ids = NULL,
  result_name = "result",
  model_rename = NULL,
  make_copy = FALSE,
  table_name = NULL
)
}
\arguments{
\item{musica}{A \code{\linkS4class{musica}} object.}

\item{modality}{Modality used for prediction.}

\item{signature_res}{Signatures to automatically subset from for prediction}

\item{model_ids}{Vector of ids for the models to combine. If null, all models
in the modality and result_list entry will be combined. Default \code{NULL}.}

\item{result_name}{Name of the result list entry containing the signatures
to plot. Default \code{"result"}.}

\item{model_rename}{New model identifier. If null, will be combination of
the ids for the models being combined. Deafult \code{NULL}.}

\item{make_copy}{If \code{FALSE}, the inputted \code{\linkS4class{musica}}
object is updated and nothing is returned. If \code{TRUE}, a new
\code{\linkS4class{musica}} object is created and returned. Default
\code{FALSE}.}

\item{table_name}{Use modality instead}
}
\value{
Returns nothing or a new \code{\linkS4class{musica}} object,
depending on the \code{make_copy} parameter.
}
\description{
Combine signatures and exposures of different models. Exposure values are
zero for samples in an annotation where that signature was not predicted
}
\examples{
data(musica_annot)
data(cosmic_v2_sigs)
grid <- auto_predict_grid(musica_annot, "SBS96", cosmic_v2_sigs, "lda",
  "Tumor_Subtypes",
  combine_res = FALSE, make_copy = TRUE
)
combined <- combine_predict_grid(grid, "SBS96", cosmic_v2_sigs,
make_copy = TRUE)
}
