% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pbFlatten.R
\name{pbFlatten}
\alias{pbFlatten}
\title{pbFlatten
Flatten pseudobulk SCE}
\usage{
pbFlatten(pb, normalize = TRUE)
}
\arguments{
\item{pb}{a pseudobulk \code{\link[SingleCellExperiment]{SingleCellExperiment}}
as returned by \code{\link{aggregateData}}, with different subpopulations as assays.}

\item{normalize}{logical specifying whether to compute a \code{logcpm} assay.}
}
\value{
a \code{\link[SingleCellExperiment]{SingleCellExperiment}}.
}
\description{
Flattens a pseudobulk \code{\link[SingleCellExperiment]{SingleCellExperiment}}
as returned by \code{\link{aggregateData}} such that all cell subpopulations 
are represented as a single assay.
}
\examples{
data(example_sce)
library(SingleCellExperiment)
pb_stack <- aggregateData(example_sce)
(pb_flat <- pbFlatten(pb_stack))
ncol(pb_flat) == ncol(pb_stack)*length(assays(pb_stack))

}
