% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pbDS.R
\name{pbDS}
\alias{pbDS}
\alias{pbDD}
\title{pseudobulk DS analysis}
\usage{
pbDS(
  pb,
  method = c("edgeR", "DESeq2", "limma-trend", "limma-voom", "DD"),
  design = NULL,
  coef = NULL,
  contrast = NULL,
  min_cells = 10,
  filter = c("both", "genes", "samples", "none"),
  treat = FALSE,
  verbose = TRUE,
  BPPARAM = SerialParam(progressbar = verbose)
)

pbDD(
  pb,
  design = NULL,
  coef = NULL,
  contrast = NULL,
  min_cells = 10,
  filter = c("both", "genes", "samples", "none"),
  verbose = TRUE,
  BPPARAM = SerialParam(progressbar = verbose)
)
}
\arguments{
\item{pb}{a \code{\link[SingleCellExperiment]{SingleCellExperiment}}
containing pseudobulks as returned by \code{\link{aggregateData}}.}

\item{method}{a character string.}

\item{design}{For methods \code{"edegR"} and \code{"limma"}, a design matrix 
with row & column names(!) created with \code{\link[stats]{model.matrix}}; 
For \code{"DESeq2"}, a formula with variables in \code{colData(pb)}.
Defaults to \code{~ group_id} or the corresponding \code{model.matrix}.}

\item{coef}{passed to \code{\link[edgeR]{glmQLFTest}},
\code{\link[limma]{contrasts.fit}}, \code{\link[DESeq2]{results}}
for \code{method = "edgeR", "limma-x", "DESeq2"}, respectively.
Can be a list for multiple, independent comparisons.}

\item{contrast}{a matrix of contrasts to test for
created with \code{\link[limma]{makeContrasts}}.}

\item{min_cells}{a numeric. Specifies the minimum number of cells in a given 
cluster-sample required to consider the sample for differential testing.}

\item{filter}{character string specifying whether
to filter on genes, samples, both or neither.}

\item{treat}{logical specifying whether empirical Bayes moderated-t 
p-values should be computed relative to a minimum fold-change threshold. 
Only applicable for methods \code{"limma-x"} 
(\code{\link[limma:eBayes]{treat}}) and \code{"edgeR"} 
(\code{\link[edgeR]{glmTreat}}), and ignored otherwise.}

\item{verbose}{logical. Should information on progress be reported?}

\item{BPPARAM}{a \code{\link[BiocParallel]{BiocParallelParam}}
object specifying how differential testing should be parallelized.}
}
\value{
a list containing \itemize{
\item a data.frame with differential testing results,
\item a \code{\link[edgeR]{DGEList}} object of length nb.-clusters, and
\item the \code{design} matrix, and \code{contrast} or \code{coef} used.}
}
\description{
\code{pbDS} tests for DS after aggregating single-cell 
  measurements to pseudobulk data, by applying bulk RNA-seq DE methods, 
  such as \code{edgeR}, \code{DESeq2} and \code{limma}.
}
\examples{
# simulate 5 clusters, 20\% of DE genes
data(example_sce)
    
# compute pseudobulk sum-counts & run DS analysis
pb <- aggregateData(example_sce)
res <- pbDS(pb, method = "limma-trend")

names(res)
names(res$table)
head(res$table$stim$`B cells`)

# count nb. of DE genes by cluster
vapply(res$table$stim, function(u) 
  sum(u$p_adj.loc < 0.05), numeric(1))

# get top 5 hits for ea. cluster w/ abs(logFC) > 1
library(dplyr)
lapply(res$table$stim, function(u)
  filter(u, abs(logFC) > 1) \%>\% 
    arrange(p_adj.loc) \%>\% 
    slice(seq_len(5)))

}
\references{
Crowell, HL, Soneson, C, Germain, P-L, Calini, D, 
Collin, L, Raposo, C, Malhotra, D & Robinson, MD: 
On the discovery of population-specific state transitions from 
multi-sample multi-condition single-cell RNA sequencing data. 
\emph{bioRxiv} \strong{713412} (2018). 
doi: \url{https://doi.org/10.1101/713412}
}
\author{
Helena L Crowell & Mark D Robinson
}
