% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmDS.R, R/utils-mmDS.R
\name{mmDS}
\alias{mmDS}
\alias{.mm_dream}
\alias{.mm_dream2}
\alias{.mm_vst}
\alias{.mm_glmm}
\title{DS analysis using mixed-models (MM)}
\usage{
mmDS(
  x,
  coef = NULL,
  covs = NULL,
  method = c("dream2", "dream", "vst", "poisson", "nbinom", "hybrid"),
  n_cells = 10,
  n_samples = 2,
  min_count = 1,
  min_cells = 20,
  verbose = TRUE,
  BPPARAM = SerialParam(progressbar = verbose),
  vst = c("sctransform", "DESeq2"),
  ddf = c("Satterthwaite", "Kenward-Roger", "lme4"),
  dup_corr = FALSE,
  trended = FALSE,
  bayesian = FALSE,
  blind = TRUE,
  REML = TRUE,
  moderate = FALSE
)

.mm_dream(
  x,
  coef = NULL,
  covs = NULL,
  dup_corr = FALSE,
  trended = FALSE,
  ddf = c("Satterthwaite", "Kenward-Roger"),
  verbose = FALSE,
  BPPARAM = SerialParam(progressbar = verbose)
)

.mm_dream2(
  x,
  coef = NULL,
  covs = NULL,
  ddf = c("Satterthwaite", "Kenward-Roger"),
  verbose = FALSE,
  BPPARAM = SerialParam(progressbar = verbose)
)

.mm_vst(
  x,
  vst = c("sctransform", "DESeq2"),
  coef = NULL,
  covs = NULL,
  bayesian = FALSE,
  blind = TRUE,
  REML = TRUE,
  ddf = c("Satterthwaite", "Kenward-Roger", "lme4"),
  verbose = FALSE,
  BPPARAM = SerialParam(progressbar = verbose)
)

.mm_glmm(
  x,
  coef = NULL,
  covs = NULL,
  family = c("poisson", "nbinom"),
  moderate = FALSE,
  verbose = TRUE,
  BPPARAM = SerialParam(progressbar = verbose)
)
}
\arguments{
\item{x}{a \code{\link[SingleCellExperiment]{SingleCellExperiment}}.}

\item{coef}{character specifying the coefficient to test.
If NULL (default), will test the last level of \code{"group_id"}.}

\item{covs}{character vector of \code{colData(x)}
column names to use as covariates.}

\item{method}{a character string.
Either \code{"dream2"} (default, lme4 with voom-weights),
\code{"dream"} (previous implementation of the dream method),
\code{"vst"} (variance-stabilizing transformation),
\code{"poisson"} (poisson GLM-MM),
\code{"nbinom"} (negative binomial GLM-MM),
\code{"hybrid"} (combination of pseudobulk and poisson methods)
or a function accepting the same arguments.}

\item{n_cells}{number of cells per cluster-sample
required to consider a sample for testing.}

\item{n_samples}{number of samples per group
required to consider a cluster for testing.}

\item{min_count}{numeric. For a gene to be tested in a given cluster,
at least \code{min_cells} must have a count >= \code{min_count}.}

\item{min_cells}{number (or fraction, if < 1) of cells with a count >
\code{min_count} required for a gene to be tested in a given cluster.}

\item{verbose}{logical specifying whether messages
on progress and a progress bar should be displayed.}

\item{BPPARAM}{a \code{\link[BiocParallel]{BiocParallelParam}}
object specifying how differential testing should be parallelized.}

\item{vst}{method to use as variance-stabilizing transformations.
\code{"sctransform"} for \code{\link[sctransform]{vst}}; \code{"DESeq2"}
for \code{\link[DESeq2]{varianceStabilizingTransformation}}.}

\item{ddf}{character string specifying the method for estimating
the effective degrees of freedom. For \code{method = "dream"},
either \code{"Satterthwaite"} (faster) or \code{"Kenward-Roger"}
(more accurate); see \code{?variancePartition::dream} for details.
For \code{method = "vst"}, method \code{"lme4"} is also valid;
see \code{\link[lmerTest]{contest.lmerModLmerTest}}.}

\item{dup_corr}{logical; whether to use
\code{\link[limma:dupcor]{duplicateCorrelation}}.}

\item{trended}{logical; whether to use expression-dependent variance priors
in \code{\link[limma]{eBayes}}.}

\item{bayesian}{logical; whether to use bayesian mixed models.}

\item{blind}{logical; whether to ignore experimental design for the vst.}

\item{REML}{logical; whether to maximize REML instead of log-likelihood.}

\item{moderate}{logical; whether to perform empirical Bayes moderation.}

\item{family}{character string specifying which GLMM to fit:
\code{"poisson"} for \code{\link[blme:blmer]{bglmer}},
\code{"nbinom"} for \code{\link[glmmTMB]{glmmTMB}}.}
}
\value{
a data.frame
}
\description{
Performs cluster-wise DE analysis by fitting cell-level models.
}
\details{
The \code{.mm_*} functions (e.g. \code{.mm_dream}) expect cells from a single
 cluster, and do not perform filtering or handle incorrect parameters well.
Meant to be called by \code{mmDS} with \code{method = c("dream", "vst")} and
\code{vst = c("sctransform", "DESeq2")} to be applied across all clusters.
\describe{
\item{\code{method = "dream2"}}{
  \code{variancePartition}'s (>=1.14.1) voom-lme4-implementation
  of mixed models for RNA-seq data; function \code{dream}.}
\item{\code{method = "dream"}}{
  \code{variancePartition}'s older voom-lme4-implementation
  of mixed models for RNA-seq data; function \code{dream}.}
\item{\code{method = "vst"}}{
  \describe{
  \item{\code{vst = "sctransform"}}{
    \code{lmer} or \code{blmer} mixed models on
    \code{\link[sctransform]{vst}} transformed counts.}
  \item{\code{vst = "DESeq2"}}{
    \code{\link[DESeq2]{varianceStabilizingTransformation}}
    followed by \code{lme4} mixed models.}}}}
}
\section{Functions}{
\itemize{
\item \code{.mm_dream()}: see details.

\item \code{.mm_dream2()}: see details.

\item \code{.mm_vst()}: see details.

\item \code{.mm_glmm()}: see details.

}}
\examples{
# subset "B cells" cluster
data(example_sce)
b_cells <- example_sce$cluster_id == "B cells"
sub <- example_sce[, b_cells]
sub$cluster_id <- droplevels(sub$cluster_id)

# downsample to 100 genes
gs <- sample(nrow(sub), 100)
sub <- sub[gs, ]

# run DS analysis using cell-level mixed-model
res <- mmDS(sub, method = "dream", verbose = FALSE)
head(res$`B cells`)

}
\references{
Crowell, HL, Soneson, C, Germain, P-L, Calini, D,
Collin, L, Raposo, C, Malhotra, D & Robinson, MD:
On the discovery of population-specific state transitions from
multi-sample multi-condition single-cell RNA sequencing data.
\emph{bioRxiv} \strong{713412} (2018).
doi: \url{https://doi.org/10.1101/713412}
}
\author{
Pierre-Luc Germain & Helena L Crowell
}
