% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runPairwiseSharing.R
\name{runPairwiseSharing}
\alias{runPairwiseSharing}
\title{Compute the proportion of (significant) QTL shared by pairs of
conditions}
\usage{
runPairwiseSharing(
  qtle,
  assay = "betas",
  assaySig = "significant",
  factor = 0.5,
  FUN = identity,
  ...
)
}
\arguments{
\item{qtle}{A `QTLExperiment` object.}

\item{assay}{The assay containing the metric used to determine sharing (i.e.
the metric to be within a factor X to be considered shared).}

\item{assaySig}{The assay containing significance information.}

\item{factor}{a number in [0,1] the factor within which effects are
considered to be shared}

\item{FUN}{a function to be applied to the estimated effect sizes before
assessing sharing. Default 'FUN=identity', 'FUN=abs' ignores
the sign of the effects when assessing sharing.}

\item{...}{Additional parameters to pass on to internal functions.}
}
\value{
The `QTLExperiment` object with a matrix called pairwiseSharing added
to the metadata.
}
\description{
Compute the proportion of (significant) QTL shared by pairs of
conditions
}
\details{
For each pair of states, the effects that are significant
(as determined by `callSignificance`) in at least one of the two states are
identified. Then the fraction of those with an estimated effect size
(i.e. betas) within a factor `factor` of one another is computed and
returned.
}
\examples{
m <- mockQTLE()
m <- callSignificance(m, assay="pvalues")
runPairwiseSharing(m) # sharing by magnitude (same sign)
runPairwiseSharing(m, factor=0) # sharing by sign
runPairwiseSharing(m, FUN=abs) # sharing by magnitude when sign is ignored

}
