% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotPairwiseSharing}
\alias{plotPairwiseSharing}
\title{Heatmap of pairwise QTL sharing with state-level annotations}
\usage{
plotPairwiseSharing(
  object,
  slot = "pairwiseSharing",
  annotateRowsBy = NULL,
  annotateColsBy = NULL,
  annotateCells = FALSE,
  colourRange = NULL,
  name = "colnames",
  distMethod = "pearson",
  size = 8,
  ...
)
}
\arguments{
\item{object}{A \code{QTLExperiment} object}

\item{slot}{Name of slot in metadata list with Pairwise Sharing matrix.}

\item{annotateRowsBy}{character or array of characters specifying the
column(s) in colData to be plotted as row annotations.}

\item{annotateColsBy}{character or array of characters specifying the
column(s) in colData to be plotted as column annotations.}

\item{annotateCells}{Logical to annotate cells with their values.}

\item{colourRange}{Optional range for the color legend}

\item{name}{character specifying the column in colData to use to label rows
and columns. Default is colnames(qtle).}

\item{distMethod}{Distance method used for hierarchical clustering. Valid
values are the supported methods in dist() function.}

\item{size}{numeric scalar giving default font size for plotting theme.}

\item{...}{Further arguments passed to \code{\link[ComplexHeatmap]{Heatmap}}.}
}
\value{
Returns a \code{ComplexHeatmap} object.
}
\description{
Methods to plot a heatmap of the pairwise sharing of QTL as calculated
by `runPairwiseSharing`.
}
\examples{
sim <- qtleSimulate(
    nStates=10, nFeatures=100, nTests=1000,
    global=0.2, multi=0.4, unique=0.2, k=2)
sim <- callSignificance(sim, mode="simple", assay="lfsrs", 
    thresh=0.0001, secondThresh=0.0002)
sim_sig <- getSignificant(sim)
sim_top <- getTopHits(sim_sig, assay="lfsrs", mode="state")
sim_top <- runPairwiseSharing(sim_top)

plotPairwiseSharing(sim_top)

# Plot with complex column annotations
plotPairwiseSharing(sim_top, annotateColsBy = c("nSignificant", "multistateGroup"))


}
