% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_functions.R
\name{getComplete}
\alias{getComplete}
\title{Filter QTLExperiment based on missing data}
\usage{
getComplete(qtle, n = 1, verbose = FALSE)
}
\arguments{
\item{qtle}{A `QTLExperiment` object}

\item{n}{Number (or percent if n < 1) of states requiring non-null values}

\item{verbose}{logical. Whether to print progress messages.}
}
\value{
a subset of the `QTLExperiment` object, with only tests with fewer
NAs than specified by n.
}
\description{
Method to filter \linkS4class{QTLExperiment} objects to remove tests with
greater than the permitted rate of missing values.
}
\examples{

# Create a QTLExperiment object with NA values ------------------------------
sim <- qtleSimulate(
    nStates=10, nFeatures=100, nTests=1000,
    global=0.2, multi=0.4, unique=0.2, k=2)
    
# Randomly remove 1000 elements from the betas matrix.
na_pattern <- sample(seq(1, ncol(sim)*nrow(sim)), 1000)
sim_na <- sim
assay(sim_na, "betas")[na_pattern] <- NA

# Original object has more rows than the output of getComplete()
dim(sim_na)

sim_complete <- getComplete(sim_na)
dim(sim_complete)



}
