% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_helper_functions.R
\name{prepare_qc_check_data}
\alias{prepare_qc_check_data}
\title{prepare_qc_check
Run simple quality control checks on the data. This checks to see how many
peptides belonging to the library were identified in the data in
each sample. Computes full length, and cleavage products independantly.}
\usage{
prepare_qc_check_data(
  processed_qf,
  peptide_library_ids = mspms::peptide_library$library_id
)
}
\arguments{
\item{processed_qf}{a QFeatures object with a SummarizedExperiment named
"peptides". Intended to be prepared by one of the pre-processing
prepare_x_data functions of the mspms R package.}

\item{peptide_library_ids}{a character vector containing the names of the
library_ids}
}
\value{
a tibble containing percentage of library_ids detected per sample,
both as full length, and as cleavage products.
}
\description{
prepare_qc_check
Run simple quality control checks on the data. This checks to see how many
peptides belonging to the library were identified in the data in
each sample. Computes full length, and cleavage products independantly.
}
\keyword{internal}
