% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_peaks.R
\name{prepare_peaks}
\alias{prepare_peaks}
\title{Prepare PEAKS label-free quantification data for MSP-MS analysis}
\usage{
prepare_peaks(
  lfq_filepath,
  colData_filepath,
  quality_threshold = 0.3,
  peptide_library = mspms::peptide_library,
  n_residues = 4
)
}
\arguments{
\item{lfq_filepath}{Path to the PEAKS `.csv` file containing peptide-level LFQ data.}

\item{colData_filepath}{Path to a `.csv` file containing sample metadata (`colData`).
Must include the columns `"quantCols"`, `"group"`, `"condition"`, and `"time"`.}

\item{quality_threshold}{Minimum quality score required for a peptide to be retained.
Peptides below this threshold are filtered out (default `0.3`).}

\item{peptide_library}{A peptide library used in the experiment, typically
`mspms::peptide_library`. Must include `"library_id"`, `"library_match_sequence"`,
and `"library_real_sequence"`.}

\item{n_residues}{Number of amino acid residues to include on each side of the
cleavage site when generating cleavage sequences (default `4`).}
}
\value{
A `QFeatures` object containing a `SummarizedExperiment` named `"peptides"`.
}
\description{
This function reads, validates, transforms, and converts a PEAKS
LFQ file into a `QFeatures` object compatible with the `mspms` workflow.
}
\examples{
lfq_filepath <- system.file(
  "extdata/peaks_protein-peptides-lfq.csv",
  package = "mspms"
)
colData_filepath <- system.file(
  "extdata/colData.csv",
  package = "mspms"
)
peaks_qf <- mspms::prepare_peaks(lfq_filepath, colData_filepath)
}
