% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_time_course.R
\name{plot_time_course}
\alias{plot_time_course}
\title{plot_time_course}
\usage{
plot_time_course(
  mspms_tidy_data,
  value_colname = "peptides_norm",
  summarize_by_mean = FALSE
)
}
\arguments{
\item{mspms_tidy_data}{tidy mspms data (prepared from QFeatures object
by mspms_tidy())}

\item{value_colname}{the name of the column containing values.}

\item{summarize_by_mean}{whether to summarise by mean (TRUE- show error bars
+- 1 standard deviation) or not (FALSE)}
}
\value{
a ggplot2 object
}
\description{
Easily plot a time course of all peptides in a QFeatures object by
peptide.
}
\examples{
# Determining peptide of interest
max_log2fc_pep <- mspms::log2fc_t_test_data \%>\%
  dplyr::filter(p.adj <= 0.05, log2fc > 3) \%>\%
  dplyr::filter(log2fc == max(log2fc)) \%>\%
  dplyr::pull(peptide)

# Defining QFeatures filter
filtered <- mspms::mspms_tidy_data \%>\%
  dplyr::filter(peptide == max_log2fc_pep) \%>\%
  plot_time_course()
}
