% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_report.R
\name{generate_report}
\alias{generate_report}
\title{generate_report}
\usage{
generate_report(
  prepared_data,
  peptide_library = mspms::peptide_library,
  n_residues = 4,
  outdir = getwd(),
  output_file = paste0(Sys.Date(), "_mspms_report.html")
)
}
\arguments{
\item{prepared_data}{a QFeatures object containing a SummarizedExperiment
named "peptides".}

\item{peptide_library}{peptide library used with experiment. Contains
columns "library_id", "library_match_sequence", and "library_real_sequence".}

\item{n_residues}{the number of amino acid residues before and after the
cleavage site to generate a cleavage seq for.}

\item{outdir}{the output directory you would like to render the
report to.}

\item{output_file}{the file name to export.}
}
\value{
a knited .html report of the mspms analysis.
}
\description{
wrapper function to generate an automatic .html report of a basic mspms
analysis.
}
\examples{
\dontshow{if (isTRUE(FALSE)) withAutoprint(\{ # examplesIf}
generate_report(mspms::peaks_prepared_data)
\dontshow{\}) # examplesIf}
}
