% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_volcano.R
\name{plot_volcano}
\alias{plot_volcano}
\title{plot_volcano}
\usage{
plot_volcano(
  log2fc_t_test_data,
  log2fc_threshold = 3,
  padj_threshold = 0.05,
  facets = "grid",
  ncol = 1
)
}
\arguments{
\item{log2fc_t_test_data}{a tibble containing the log2fc
and adjusted p values}

\item{log2fc_threshold}{the log2fc threshold that you want displayed on plot}

\item{padj_threshold}{the padj threshold that you want displayed on plot}

\item{facets}{how facets should be displayed. Accepted values are grid and
wrap}

\item{ncol}{ncol to include if facets = "wrap"}
}
\value{
a ggplot2 object
}
\description{
create a volcano plot to generate log2fc and adjusted p values for
experimental conditions
}
\examples{
p1 <- mspms::plot_volcano(mspms::log2fc_t_test_data, log2fc_threshold = 3)
p1
}
