% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/purityD-constructor.R
\name{initialize,purityD-method}
\alias{initialize,purityD-method}
\title{Constructor for S4 class to represent a DI-MS purityD}
\usage{
\S4method{initialize}{purityD}(.Object, fileList, cores = 1, mzML = TRUE, mzRback = "pwiz")
}
\arguments{
\item{.Object}{object; purityD object}

\item{fileList}{data.frame; created using GetFiles, data.frame with filepaths and sample class information}

\item{cores}{numeric; Number of cores used to perform Hierarchical clustering WARNING: memory intensive, default 1}

\item{mzML}{boolean; TRUE if mzML to be used FALSE if .csv file to be used}

\item{mzRback}{character; backend to use for mzR parsing}
}
\value{
purityD object
}
\description{
The class used to predict purity from an DI-MS dataset.
}
\examples{
datapth <- system.file("extdata", "dims", "mzML", package="msPurityData")
inDF <- Getfiles(datapth, pattern=".mzML", check = FALSE, cStrt = FALSE)
ppDIMS <- purityD(fileList=inDF, cores=1, mzML=TRUE)
}
