% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/purityA-create-msp.R
\name{createMSP,purityA-method}
\alias{createMSP,purityA-method}
\alias{createMSP}
\title{Using a purityA object, create an MSP file of fragmentation spectra}
\usage{
\S4method{createMSP}{purityA}(
  pa,
  msp_file_pth = NULL,
  metadata = NULL,
  metadata_cols = NULL,
  xcms_groupids = NULL,
  method = "all",
  adduct_split = TRUE,
  filter = TRUE,
  msp_schema = "massbank",
  intensity_ra = "intensity_ra",
  include_adducts = ""
)
}
\arguments{
\item{pa}{object;  purityA object}

\item{msp_file_pth}{character; Name of the output msp file, if NULL the file "frag_spectra_{time stamp}.msp" will be created in the current directory}

\item{metadata}{data.frame; Data frame with additional coumpound infomation to include in msp output}

\item{metadata_cols}{vector; Column names of meta data to incorporate into name}

\item{xcms_groupids}{vector; XCMS group id's to extract ms/ms data for}

\item{method}{character; "all" will export all matching ms/ms spectra to xcms features, "max" will use spectra with the highest inensity,
"av_intra" will use the intra file averaged spectra (within file), "av_inter" will use the inter file (across file)
averaged spectra, "av_all" will use the averaged spectra (ignoring inter and intra)}

\item{adduct_split}{boolean; If either "adduct" or  MS$FOCUSED_ION: PRECURSOR_TYPE column is in metadata then each adduct will have it's own MSP spectra.
(Useful, if the MSP file will be used for further annotation)}

\item{filter}{boolean; TRUE if filtered peaks are to be removed}

\item{msp_schema}{character; Either MassBank (Europe) or MoNA style of MSP file format to be used ('massbank' or 'mona')}

\item{intensity_ra}{character; Either 'intensity', 'ra' (relative abundance) or 'intensity_ra' (intensity and relative abundance) to be written
to the MSP file}

\item{include_adducts}{character; Additional adducts to include as a string seperated by white a space (e.g. [M+H]+ [M+Na]+)}
}
\value{
Returns a MSP file with the selected spectra and metadata
}
\description{
\strong{General}

Create an MSP file for all the fragmentation spectra that has been linked to an XCMS feature via frag4feature.
Can export all the associated scans individually or the averaged fragmentation spectra can be exported.

Additional metadata can be included in a dataframe (each column will be added to metadata of the MSP spectra).
The dataframe must contain the column "grpid" corresponding to the XCMS grouped feature.

\strong{Example LC-MS/MS processing workflow}
\itemize{
\item Purity assessments
\itemize{
\item (mzML files) -> \strong{purityA} -> (pa)
}
\item XCMS processing
\itemize{
\item (mzML files) -> xcms.findChromPeaks -> (optionally) xcms.adjustRtime -> xcms.groupChromPeaks -> (xcmsObj)
\item --- \emph{Older versions of XCMS} --- (mzML files) -> xcms.xcmsSet -> xcms.group -> xcms.retcor -> xcms.group -> (xcmsObj)
}
\item Fragmentation processing
\itemize{
\item (xcmsObj, pa) -> frag4feature -> filterFragSpectra -> averageIntraFragSpectra -> averageIntraFragSpectra -> \strong{createMSP} -> (MSP file)
}
}
}
\examples{

#====== XCMS =================================
## Read in MS data
#msmsPths <- list.files(system.file("extdata", "lcms", "mzML",
#           package="msPurityData"), full.names = TRUE, pattern = "MSMS")
#ms_data = readMSData(msmsPths, mode = 'onDisk', msLevel. = 1)

## Find peaks in each file
#cwp <- CentWaveParam(snthresh = 5, noise = 100, ppm = 10, peakwidth = c(3, 30))
#xcmsObj  <- xcms::findChromPeaks(ms_data, param = cwp)

## Optionally adjust retention time
#xcmsObj  <- adjustRtime(xcmsObj , param = ObiwarpParam(binSize = 0.6))

## Group features across samples
#pdp <- PeakDensityParam(sampleGroups = c(1, 1), minFraction = 0, bw = 30)
#xcmsObj <- groupChromPeaks(xcmsObj , param = pdp)

#====== msPurity ============================
#pa  <- purityA(msmsPths)
#pa <- frag4feature(pa = pa, xcmsObj = xcmsObj)
#pa <- filterFragSpectra(pa, allfrag=TRUE)
#pa <- averageAllFragSpectra(pa)
#createMSP(pa)

pa <- readRDS(system.file("extdata", "tests", "purityA",
                          "9_averageAllFragSpectra_with_filter_pa.rds",
                          package="msPurity"))
createMSP(pa)
}
