% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_motifs.R
\docType{methods}
\name{motifCounts}
\alias{motifCounts}
\alias{motifCounts,SummarizedExperiment-method}
\title{motifCounts}
\usage{
motifCounts(object)

\S4method{motifCounts}{SummarizedExperiment}(object)
}
\arguments{
\item{object}{SummarizedExperiment object with counts assay}
}
\value{
matrix with counts
}
\description{
get motif counts from SummarizedExperiment object
}
\section{Methods (by class)}{
\itemize{
\item \code{SummarizedExperiment}: method for SummarizedExperiment
}}

\examples{

data(example_motifs, package = "motifmatchr")

# Make a set of peaks
peaks <- GenomicRanges::GRanges(seqnames = c("chr1","chr2","chr2"),
                ranges = IRanges::IRanges(start = c(76585873,42772928,
                                          100183786),
                                          width = 500))

# Get motif matches for example motifs
motif_ix <- matchMotifs(example_motifs, peaks,
                         genome = "BSgenome.Hsapiens.UCSC.hg19",
                         out = "scores")

motifCounts(motif_ix)
}
