% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_motifs.R
\docType{methods}
\name{matchMotifs}
\alias{matchMotifs}
\alias{matchMotifs,PWMatrixList,DNAStringSet-method}
\alias{matchMotifs,PWMatrixList,character-method}
\alias{matchMotifs,PWMatrixList,DNAString-method}
\alias{matchMotifs,PWMatrixList,GenomicRanges-method}
\alias{matchMotifs,PWMatrixList,RangedSummarizedExperiment-method}
\alias{matchMotifs,PWMatrixList,BSgenomeViews-method}
\alias{matchMotifs,PFMatrixList,ANY-method}
\alias{matchMotifs,PWMatrix,ANY-method}
\alias{matchMotifs,PFMatrix,ANY-method}
\title{matchMotifs}
\usage{
matchMotifs(pwms, subject, ...)

\S4method{matchMotifs}{PWMatrixList,DNAStringSet}(pwms, subject,
  genome = NULL, bg = c("subject", "genome", "even"), out = c("matches",
  "scores", "positions"), p.cutoff = 5e-05, w = 7, ranges = NULL)

\S4method{matchMotifs}{PWMatrixList,character}(pwms, subject, genome = NULL,
  bg = c("subject", "genome", "even"), out = c("matches", "scores",
  "positions"), p.cutoff = 5e-05, w = 7, ranges = NULL)

\S4method{matchMotifs}{PWMatrixList,DNAString}(pwms, subject, genome = NULL,
  bg = c("subject", "genome", "even"), out = c("matches", "scores",
  "positions"), p.cutoff = 5e-05, w = 7, ranges = NULL)

\S4method{matchMotifs}{PWMatrixList,GenomicRanges}(pwms, subject,
  genome = Seqinfo::genome(subject), bg = c("subject", "genome",
  "even"), out = c("matches", "scores", "positions"), p.cutoff = 5e-05,
  w = 7)

\S4method{matchMotifs}{PWMatrixList,RangedSummarizedExperiment}(pwms, subject,
  genome = Seqinfo::genome(subject), bg = c("subject", "genome",
  "even"), out = c("matches", "scores", "positions"), p.cutoff = 5e-05,
  w = 7)

\S4method{matchMotifs}{PWMatrixList,BSgenomeViews}(pwms, subject,
  bg = c("subject", "genome", "even"), out = c("matches", "scores",
  "positions"), p.cutoff = 5e-05, w = 7)

\S4method{matchMotifs}{PFMatrixList,ANY}(pwms, subject, ...)

\S4method{matchMotifs}{PWMatrix,ANY}(pwms, subject, ...)

\S4method{matchMotifs}{PFMatrix,ANY}(pwms, subject, ...)
}
\arguments{
\item{pwms}{either \code{\link[TFBSTools]{PFMatrix}},
\code{\link[TFBSTools]{PFMatrixList}}, \code{\link[TFBSTools]{PWMatrix}},
\code{\link[TFBSTools]{PWMatrixList}}}

\item{subject}{either \code{\link[GenomicRanges]{GenomicRanges}},
\code{\link[Biostrings]{DNAStringSet}}, \code{\link[Biostrings]{DNAString}},
or character vector}

\item{...}{additional arguments depending on inputs}

\item{genome}{BSgenome object, \code{\link[Biostrings]{DNAStringSet}}, or
\code{\link[Rsamtools]{FaFile}}, or short string signifying genome build
recognized by \code{\link[BSgenome]{getBSgenome}}. Only required if
subject is \code{\link[GenomicRanges]{GenomicRanges}} or
\code{\link[SummarizedExperiment]{RangedSummarizedExperiment}} or if bg is set
to "genome"}

\item{bg}{background nucleotide frequencies. Default is to compute based on
subject, i.e. the specific set of sequences being evaluated. See Details.}

\item{out}{what to return? see return section}

\item{p.cutoff}{p-value cutoff for returning motifs}

\item{w}{parameter controlling size of window for filtration; default is 7}

\item{ranges}{if subject is not GenomicRanges or RangedSummarizedExperiment,
these ranges can be used to specify what ranges the input sequences
correspond to. These ranges will be incorporated into the
SummarizedExperiment output if out is "matches" or "scores" or will be used
to give absolute positions of motifs if out is "positions"}
}
\value{
Either returns a SummarizedExperiment with a sparse matrix with
 values set to TRUE for a match (if out == 'matches'), a
 SummarizedExperiment with a matches matrix as well as matrices with the
 maximum motif score and total motif counts (if out == 'scores'), or a
 \code{\link[GenomicRanges]{GenomicRangesList}} or a list of
 \code{\link[IRanges]{IRangesList}} with all the positions of matches
 (if out == 'positions')
}
\description{
Find motif matches
}
\details{
Background nucleotide frequencies can be set to "subject" to use the
subject sequences or ranges for computing the nucleotide frequencies,
"genome" for using the genomice frequencies (in which case a genome must be
specified), "even" for using 0.25 for each base, or a numeric vector with A,
C, G, and T frequencies.
}
\section{Methods (by class)}{
\itemize{
\item \code{pwms = PWMatrixList,subject = DNAStringSet}: PWMatrixList/DNAStringSet

\item \code{pwms = PWMatrixList,subject = character}: PWMatrixList/character

\item \code{pwms = PWMatrixList,subject = DNAString}: PWMatrixList/DNAString

\item \code{pwms = PWMatrixList,subject = GenomicRanges}: PWMatrixList/GenomicRanges

\item \code{pwms = PWMatrixList,subject = RangedSummarizedExperiment}: PWMatrixList/RangedSummarizedExperiment

\item \code{pwms = PWMatrixList,subject = BSgenomeViews}: PWMatrixList/BSGenomeViews

\item \code{pwms = PFMatrixList,subject = ANY}: PFMatrixList/ANY

\item \code{pwms = PWMatrix,subject = ANY}: PWMatrix/ANY

\item \code{pwms = PFMatrix,subject = ANY}: PFMatrix/ANY
}}

\examples{

data(example_motifs, package = "motifmatchr")

# Make a set of peaks
peaks <- GenomicRanges::GRanges(seqnames = c("chr1","chr2","chr2"),
                ranges = IRanges::IRanges(start = c(76585873,42772928,
                                          100183786),
                                          width = 500))

# Get motif matches for example motifs
motif_ix <- matchMotifs(example_motifs, peaks, genome = "BSgenome.Hsapiens.UCSC.hg19")

}
