% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forground_wrapper.R
\name{normalizeMotif}
\alias{normalizeMotif}
\title{Normalizes a PFM}
\usage{
normalizeMotif(pfm, pseudo = 0.01)
}
\arguments{
\item{pfm}{An R matrix that represents a position frequency matrix}

\item{pseudo}{Small numeric pseudo-value that is added
to each entry in the PFM in order to ensure strictly positive entries.
Default: pseudo = 0.01}
}
\value{
A normalized PFM
}
\description{
This function normalizes a PFM and optionally
adds pseudo-evidence to each entry of the matrix.
}
\examples{

# Load motif
motiffile = system.file("extdata", "x1.tab", package = "motifcounter")
motif = t(as.matrix(read.table(motiffile)))

# Normalize motif
new_motif = normalizeMotif(motif)

}
