% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichmentTest.R
\name{motifEnrichment}
\alias{motifEnrichment}
\title{Enrichment of motif hits}
\usage{
motifEnrichment(seqs, pfm, bg, singlestranded = FALSE, method = "compound")
}
\arguments{
\item{seqs}{A DNAStringSet or DNAString object}

\item{pfm}{An R matrix that represents a position frequency matrix}

\item{bg}{A Background object}

\item{singlestranded}{Boolean that indicates whether a single strand or
both strands shall be scanned for motif hits.
Default: singlestranded = FALSE.}

\item{method}{String that defines whether to use
the 'compound' Poisson approximation' or the 'combinatorial' model.
Default: method='compound'.}
}
\value{
List that contains
\describe{
\item{pvalue}{P-value for the enrichment test}
\item{fold}{Fold-enrichment with respect to the expected number of hits}
}
}
\description{
This function determines whether a given motif is enriched in a given
DNA sequences.
}
\details{
Enrichment is tested by comparing the observed 
number of motif hits against a theoretical distribution of the number
of motif hits in random DNA sequences.
Optionally, the theoretical distribution of the number of motif
hits can be evaluated by either a 'compound Poisson model' 
or the 'combinatorial model'.
Additionally, the enrichment test can be conducted with respect
to scanning only the forward strand or both strands of the DNA
sequences. The latter option is only available for the
'compound Poisson model'
}
\examples{


# Load sequences
seqfile = system.file("extdata", "seq.fasta", package = "motifcounter")
seqs = Biostrings::readDNAStringSet(seqfile)

# Load background
bg = readBackground(seqs, 1)

# Load motif
motiffile = system.file("extdata", "x31.tab", package = "motifcounter")
motif = t(as.matrix(read.table(motiffile)))

# 1 ) Motif enrichment test w.r.t. scanning a *single* DNA strand
# based on the 'Compound Poisson model'

result = motifEnrichment(seqs, motif, bg,
            singlestranded = TRUE, method = "compound")

# 2 ) Motif enrichment test w.r.t. scanning *both* DNA strand
# based on the 'Compound Poisson model'

result = motifEnrichment(seqs, motif, bg, method = "compound")

# 3 ) Motif enrichment test w.r.t. scanning *both* DNA strand
# based on the *combinatorial model*

result = motifEnrichment(seqs, motif, bg, singlestranded = FALSE,
            method = "combinatorial")

}
\seealso{
\code{\link{compoundPoissonDist}}, \code{\link{combinatorialDist}}
}
