% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simMultiMotifs.R
\name{simMultiMotifs}
\alias{simMultiMotifs}
\title{Simulate sequences with multiple motifs}
\usage{
simMultiMotifs(
  n,
  width,
  pfm = NULL,
  bg = NULL,
  nt = c("A", "C", "G", "T"),
  prob = rep(0.25, 4),
  shape1 = 1,
  shape2 = shape1,
  rate = NA,
  theta = NA,
  as = "DNAStringSet",
  ol = c("random", "first", "last"),
  ...
)
}
\arguments{
\item{n}{The number of sequences to simulate}

\item{width}{Width of sequences to simulate}

\item{pfm}{List of Probability Weight/Frequency Matrices}

\item{bg}{Optional, pre-defined set of background sequences. Can be passed as
an XStringSet or character vector. All sequences must be the same width}

\item{nt}{Nucleotides to include}

\item{prob}{Sampling probabilities for each nucleotide}

\item{shape1, shape2}{Passed to \link[VGAM]{rbetabinom.ab}}

\item{rate}{The expected rate of motifs per sequence. Is equivalent to
\eqn{ \lambda } in \link[stats]{rpois}. If set to NULL or NA, all sequences will
be simulated with a single motif, otherwise a Poisson distribution will be used}

\item{theta}{Overdispersion parameter passed to \link[MASS]{rnegbin}.
If set to NULL or NA the rate parameter will be passed to \link[stats]{rpois}.
However if this value is set, the rate and theta parameters are passed to
\link[MASS]{rnegbin} to simulate overdispersed counts}

\item{as}{ObjectClass to return objects as. Defaults to DNAStringSet, but
other viable options may include 'character', 'CharacterList' or any
other class from which a character vector may be coerced.}

\item{ol}{When randomly simulated positions overlap, choose one either at
random, by the first occurring PFM in the list of PFMs, or by the last.}

\item{...}{Not used}
}
\value{
A DNAStringSet with mcols denoting the positions of all inserted motifs
}
\description{
Simulate a set of sequences incorporating multiple motifs
}
\details{
Simulate a set of sequences with multiple motifs inserted using different
rates and distributions, as specified.
All shape, rate and theta parameters are recycled to match the length of the
supplied motif list, and can be supplied as vectors to tailor these
parameters to each provided element of the list of matrices
}
\examples{
data("ex_pfm")
## Simulate sequences including both ESR1 and ANDR, but with
## ESR1 being included at a higher rate
seq <- simMultiMotifs(10, 100, ex_pfm[1:2], rate = c(2, 1))
seq
## The positions of the motifs are included in the mcols
mcols(seq)


}
