% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reorderUPGMAtree.R
\name{reorderUPGMAtree}
\alias{reorderUPGMAtree}
\title{re-order UPGMA tree}
\usage{
reorderUPGMAtree(phylog, motifs, rcpostfix = "(RC)")
}
\arguments{
\item{phylog}{an object of phylog}

\item{motifs}{a list of objects of pfm}

\item{rcpostfix}{the postfix for reverse complements}
}
\value{
an object of phylog
}
\description{
re-order the UPGMA tree by adjacent motif distance
}
\examples{

  if(interactive() || Sys.getenv("USER")=="jianhongou"){
    library("MotifDb")
    matrix.fly <- query(MotifDb, "Dmelanogaster")
    motifs <- as.list(matrix.fly)
    motifs <- motifs[grepl("Dmelanogaster-FlyFactorSurvey-", names(motifs), fixed=TRUE)]
    names(motifs) <- gsub("Dmelanogaster_FlyFactorSurvey_", "", 
                gsub("_FBgn[0-9]+$", "", 
                  gsub("[^a-zA-Z0-9]","_", 
                     gsub("(_[0-9]+)+$", "", names(motifs)))))
    motifs <- motifs[unique(names(motifs))]
    pfms <- sample(motifs, 50)
    hc <- clusterMotifs(pfms)
    library(ade4)
    phylog <- ade4::hclust2phylog(hc)
    pfms <- mapply(pfms, names(pfms), FUN=function(.ele, .name){
                 new("pfm",mat=.ele, name=.name)})
    reorderUPGMAtree(phylog, pfms)
  }

}
\author{
Jianhong Ou
}
\keyword{misc}
