% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color_mgmt.R
\name{map_to_color}
\alias{map_to_color}
\title{Maps numeric values to color values}
\usage{
map_to_color(x, pal, symmetric = TRUE, limits = NULL)
}
\arguments{
\item{x}{A character vector of numeric values (e.g. log2FoldChange values) to
be converted to a vector of colors}

\item{pal}{A vector of characters specifying the definition of colors for the
palette, e.g. obtained via \code{\link[RColorBrewer:ColorBrewer]{RColorBrewer::brewer.pal()}}}

\item{symmetric}{Logical value, whether to return a palette which is symmetrical
with respect to the minimum and maximum values - "respecting" the zero.
Defaults to \code{TRUE}.}

\item{limits}{A vector containing the limits of the values to be mapped. If
not specified, defaults to the range of values in the \code{x} vector.}
}
\value{
A vector of colors, each corresponding to an element in the original
vector
}
\description{
Maps numeric continuous values to values in a color palette
}
\examples{
a <- 1:9
pal <- RColorBrewer::brewer.pal(9, "Set1")
map_to_color(a, pal)
plot(a, col = map_to_color(a, pal), pch = 20, cex = 4)

b <- 1:50
pal2 <- grDevices::colorRampPalette(
  RColorBrewer::brewer.pal(name = "RdYlBu", 11)
)(50)
plot(b, col = map_to_color(b, pal2), pch = 20, cex = 3)
}
