% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bicluster_net_methods.R
\name{node_size}
\alias{node_size}
\title{Node sizes for plotting bicluster networks.}
\usage{
node_size(bics, base_size = 10, offset = 0.2, MARGIN = "column")
}
\arguments{
\item{bics}{A list of \code{\link{bicluster}} objects.}

\item{base_size}{Is multiplied with the atan result for the node size}

\item{offset}{Offset for the atan calculation. Has to be > 0.
Smaller values result in higher differences of node sizes.}

\item{MARGIN}{"column", "row" or "both" are taken into account
for the size of a bicluster bicluster}
}
\value{
Vector of node sizes as floats.
}
\description{
When plotting bicluster networks, node sizes adapted to bicluster sizes
can improve visual inspection.
Node sizes are computed using the following formula:
\code{(atan( (x - min(x)) / (max(x) - min(x)) + offset ) * base_size)}.
With x being defined a vector of bicluster sizes defined
by the \code{MARGIN} parameter.
}
\examples{
m <- matrix(seq(1:16), nrow=4)
# m <- matrix(rnorm(10000), nrow=100)
# bics <- c(run_fabia(m), run_isa(m), run_plaid(m))
# bn <- bicluster_network(bics, m)
# nz <- node_size(bics)
# plot_algo_network(bn, bics, vertex.size=nz)
# plot(bn, vertex.size=node_size(bics, offset=.1, base_size=15))

}
