% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{attributeConnector}
\alias{attributeConnector}
\title{Extract the class-wise degree of an adjacency matrix.}
\usage{
attributeConnector(mat, otherclasses, useOther = FALSE)
}
\arguments{
\item{mat}{A adjacency matrix with bipartite interactions as 
computed by \code{\link{full_graph}} or \code{\link{attribute_graph}} 
(with parameter \code{bipartite=TRUE}).}

\item{otherclasses}{A logical vector indicating two classes 
of elements in rows (columns).}

\item{useOther}{Logical indicating if the attributes, that 
are classified appear first in the matrix (\code{True}) or 
the attributes that connect classified attributes (\code{False}).}
}
\value{
A DataFrame that holds the total degree of every 
attribute (row/column) and the fraction of the degree that 
connects only to elements of class \code{True} (from 
parameter \code{otherclasses}).
}
\description{
For a adjacency matrix as computed by \code{\link{full_graph}},
the function computes how many row-column interactions connect 
rows (columns) to columns (rows) of a specific class/category.
}
\examples{
m <- matrix(seq(1:16), nrow=4)
# m <- matrix(rnorm(10000), nrow=100)
# bics <- c(run_fabia(m), run_isa(m), run_plaid(m))
# fn <- feature_network(bics, m)
# attributeConnector(apply_threshold(fn), 
#     otherclasses=c(rep(FALSE, 100), rep(TRUE, 100)))

}
