% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_random_regions.R
\name{sampleRandomRegions}
\alias{sampleRandomRegions}
\title{Sample random regions of fixed length.}
\usage{
sampleRandomRegions(allowedRegions = NULL, N = 100L, regWidth = 200L)
}
\arguments{
\item{allowedRegions}{An unstranded \code{GRanges} object of the "allowed" 
of the genome, usually the mappable regions.}

\item{N}{Number of regions to sample.}

\item{regWidth}{Region width.}
}
\value{
A \code{GRanges} object with randomly sampled mappable regions of 
    width \code{regWidth} with \code{fractionCGI} coming from CpG islands.
}
\description{
Sample random regions from the mappable parts of the genome with
    a given fraction from CpG islands.
}
\details{
In order to make the results deterministic, set the random
    number seed before calling \code{sampleRandomRegions} using 
    \code{set.seed}.
}
\examples{
regs <- GenomicRanges::GRanges(
  seqnames = rep(c("chr1", "chr2"), each = 2), 
  ranges = IRanges::IRanges(start = 1:4, end = 5:8))
set.seed(123)
sampleRandomRegions(regs, N = 2, regWidth = 3L)

}
