% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plotBinScatter}
\alias{plotBinScatter}
\title{Scatter plot (xy-plot) of binned elements.}
\usage{
plotBinScatter(
  x,
  y,
  b,
  cols = NULL,
  xlab = deparse(substitute(x, env = as.environment(-1))),
  ylab = deparse(substitute(y, env = as.environment(-1))),
  main = "",
  legendPosition = "right",
  legend = NULL,
  legend.cex = NULL,
  ...
)
}
\arguments{
\item{x}{A numerical vector with x values.}

\item{y}{A numerical vector with y values (the values used for binning).}

\item{b}{A factor that groups elements of \code{x,y} into bins (typically
the output of \code{\link{bin}(y)}).}

\item{cols}{\code{NULL} or a color vector defining the colors of points.
If \code{NULL}, the colors will be computed based on \code{b} using
\code{\link{getColsByBin}(b)}).}

\item{xlab}{Label for x-axis.}

\item{ylab}{Label for y-axis.}

\item{main}{Main title.}

\item{legendPosition}{A \code{character} scalar.
If not \code{"none"}, draw a legend with binning information. The value
is used to control the legend position and will be passed to
\code{theme(legend.position = legendPosition)}.}

\item{legend}{Deprecated (ignored). Please use \code{legendPosition} to
control the drawing and position of the legend.}

\item{legend.cex}{Deprecated (ignored). You can use
\code{\link[ggplot2]{theme}} to set legend and other graphical
parameters.}

\item{...}{Further arguments passed to \code{\link{getColsByBin}} (only used
if \code{cols} is \code{NULL}).}
}
\value{
The generated scatter plot as a \code{ggplot} object.
}
\description{
Plot a scatter (xy-plot) of binned elements with binning
    information.
}
\examples{
set.seed(1)
x <- rnorm(100)
y <- rnorm(100)
b <- bin(y, "equalN", nElements = 10)
plotBinScatter(x, y, b)

}
\seealso{
\code{\link{bin}}, \code{\link{getColsByBin}},
    \code{\link[ggplot2]{geom_point}}
}
