% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motif_enrichment_HOMER.R
\name{homerToPFMatrixList}
\alias{homerToPFMatrixList}
\title{Read a HOMER motif file and create a PFMatrixList}
\usage{
homerToPFMatrixList(filename, n = 100L)
}
\arguments{
\item{filename}{Name of the input file with HOMER-formatted motifs.}

\item{n}{The number of observations (multiplied with base frequencies to
create the number of observed bases at each position).}
}
\value{
A \code{\link[TFBSTools]{PFMatrixList}} with motifs from the file.
}
\description{
Read motifs from a file in HOMER format and create
    a PFMatrixList from them.
}
\examples{
library(JASPAR2020)
optsL <- list(ID = c("MA0006.1"))
pfm1 <- TFBSTools::getMatrixSet(JASPAR2020, opts = optsL)
TFBSTools::Matrix(pfm1)

tmpfn <- tempfile()
dumpJaspar(filename = tmpfn, pkg = "JASPAR2020", opts = optsL)
pfm2 <- homerToPFMatrixList(tmpfn)
TFBSTools::Matrix(pfm2)

unlink(tmpfn)

}
\seealso{
\code{\link{dumpJaspar}} for writing motifs from a Jaspar database
    package into a file in HOMER format.
}
