% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_enrichment.R
\name{.filterSeqs}
\alias{.filterSeqs}
\title{Filter Sequences}
\usage{
.filterSeqs(
  seqs,
  maxFracN = 0.7,
  minLength = 5L,
  maxLength = 100000L,
  verbose = FALSE
)
}
\arguments{
\item{seqs}{A \code{DNAStringSet} object.}

\item{maxFracN}{A numeric scalar with the maximal fraction of N bases allowed
in a sequence (defaults to 0.7).}

\item{minLength}{The minimum sequence length (default from Homer).
Sequences shorter than this will be filtered out.}

\item{maxLength}{The maximum sequence length (default from Homer).
Sequences bigger than this will be filtered out.}

\item{verbose}{A logical scalar. If \code{TRUE}, report on filtering.}
}
\value{
A logical vector of the same length as \code{seqs} with \code{TRUE}
  indicated to keep the sequence and \code{FALSE} to filter it out.
}
\description{
Filter sequences that are unlikely to be useful for motif
  enrichment analysis. The current defaults are based on HOMER
  (version 4.11).
}
\details{
The filtering logic is based on \code{removePoorSeq.pl} from Homer.
}
\keyword{internal}
