% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/motif_enrichment_monaLisa.R
\name{.calcMotifEnrichment}
\alias{.calcMotifEnrichment}
\title{Calculate motif enrichment}
\usage{
.calcMotifEnrichment(
  motifHitMatrix,
  df,
  test = c("fisher", "binomial"),
  verbose = FALSE
)
}
\arguments{
\item{motifHitMatrix}{Matrix with 0 and 1 entries for absence or presence of
motif hits in each sequence.}

\item{df}{A \code{DataFrame} with sequence information as returned by
\code{.iterativeNormForKmers()}.}

\item{test}{Type of motif enrichment test to perform.}

\item{verbose}{A logical scalar. If \code{TRUE}, report on progress.}
}
\value{
A \code{data.frame} containing the motifs as rows and the columns:
  \describe{
    \item{motifName}{: the motif name}
    \item{logP}{: the log p-value for enrichment (natural logarithm).
       If \code{test="binomial"} (default), this log p-value is identical to
       the one returned by Homer.}
    \item{sumForegroundWgtWithHits}{: the sum of the weights of the
       foreground sequences that have at least one instance of a specific
       motif (ZOOPS mode).}
    \item{sumBackgroundWgtWithHits}{: the sum of the weights of the
       background sequences that have at least one instance of a specific
       motif (ZOOPS mode).}
    \item{totalWgtForeground}{: the total sum of weights of foreground
       sequences.}
    \item{totalWgtBackground}{: the total sum of weights of background
       sequences.}
  }
}
\description{
Given motif counts, foreground/background labels and
  weights for a set of sequences, calculate the enrichment of each motif
  in foreground compared to background. This function is called by
  \code{calcBinnedMotifEnrR()} for each bin.

  The default type of test is \code{"fisher"}, which is also what
  \code{Homer} uses if "-h" is specified for a hypergeometric test.
  Alternatively, a binomial test can be used by \code{test = "binomial"}
  (what \code{Homer} does by default). Using Fisher's exact test has
  the advantage that special cases such as zero background counts are
  handled without ad-hoc adjustments to the frequencies.

  For \code{test = "fisher"}, \code{fisher.test} is used with
  \code{alternative = "greater"}, making it a one-sided test for enrichment,
  as is the case with the binomial test.
}
\keyword{internal}
