% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binning.R
\name{bin}
\alias{bin}
\title{Bin elements of \code{x}.}
\usage{
bin(
  x,
  binmode = c("equalN", "equalWidth", "breaks"),
  nElements = round(length(x)/5),
  nBins = NULL,
  minAbsX = NULL,
  breaks = NULL,
  ...
)
}
\arguments{
\item{x}{A numerical vector with the values used for binning.}

\item{binmode}{The algorithm to be used for binning. Possible values are:
"equalN" (default), "equalWidth" or "breaks" (see Details).}

\item{nElements}{The number of elements per bin (only for
\code{binmode="equalN"}). The width of bins is adjusted accordingly.}

\item{nBins}{The number of bins (only for \code{binmode="equalWidth"}). The
number of elements per bin will be variable.}

\item{minAbsX}{The minimal absolute value in \code{x} for elements to be
binned using the \code{binmode="equalN"} or \code{binmode="equalWidth"}
(ignored for other values of \code{binmode}). Elements with \code{x} values
in \code{[-minAbsX,minAbsX]} will be collected in a single bin.}

\item{breaks}{Numerical vector with bin boundaries (only for
\code{binmode="breaks"}). \code{breaks} has to be ordered and strictly
increasing, and has to be of length (number of bins) + 1.}

\item{...}{Further arguments to be passed to \code{cut(x, breaks,
include.lowest = TRUE, ...)}, such as \code{labels=FALSE}.}
}
\value{
The return value from \code{cut(x, ...)}, typically a factor of the
  same length as \code{x}. Binning mode, bin boundaries and the "neutral" bin
  are available from \code{attr(..., "binmode")}, \code{attr(..., "breaks")}
  and \code{attr(..., "bin0")}. For \code{binmode = "breaks"}, the latter
  will be \code{NA}.
}
\description{
\code{bin} groups elements of \code{x} into bins with either a
  constant number of elements per bin, a constant bin width or according to
  user-provided bin boundaries.
}
\details{
Elements are binned according to the values in \code{x} depending on
  \code{binmode}:
  \describe{
  \item{equalN}{Items are grouped into a variable
  number of bins with \code{nElements} elements each. If \code{minAbsX} is
  not \code{NULL}, elements with \code{x}-values in \code{[-minAbsX,minAbsX]}
  will first be collected in a single bin before binning the remaining
  elements. The boundaries of this single bin may be slightly adjusted in
  order to respect the \code{nElements} elements in the other bins.}
  \item{equalWidth}{Items are group into \code{nBins} bins with a variable
  number of elements each.}
  \item{breaks}{Items are grouped into bins using
  \code{cut(x, breaks, include.lowest = TRUE)}}
  }
}
\examples{
set.seed(1)
x <- rnorm(100)
summary(bin(x, "equalN", nElements=10))
summary(bin(x, "equalN", nElements=10, minAbsX=0.5))
summary(bin(x, "equalWidth", nBins=5))
summary(bin(x, "breaks", breaks=c(-10,-1,0,1,10)))

}
\seealso{
\code{\link{cut}} which is used internally.
}
