% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plotMotifHeatmaps}
\alias{plotMotifHeatmaps}
\title{Heatmap of motif enrichments.}
\usage{
plotMotifHeatmaps(
  x,
  which.plots = c("negLog10P", "pearsonResid", "negLog10Padj", "log2enr"),
  width = 4,
  col.enr = c("#053061", "#2166AC", "#4393C3", "#92C5DE", "#D1E5F0", "#F7F7F7",
    "#FDDBC7", "#F4A582", "#D6604D", "#B2182B", "#67001F"),
  col.sig = c("#F0F0F0", "#D9D9D9", "#BDBDBD", "#969696", "#737373", "#525252",
    "#252525", "#000000"),
  col.gc = c("#F7FCF5", "#E5F5E0", "#C7E9C0", "#A1D99B", "#74C476", "#41AB5D", "#238B45",
    "#006D2C", "#00441B"),
  maxEnr = NULL,
  maxSig = NULL,
  highlight = NULL,
  cluster = FALSE,
  show_dendrogram = FALSE,
  show_motif_GC = FALSE,
  show_seqlogo = FALSE,
  show_bin_legend = FALSE,
  width.seqlogo = 1.5,
  use_raster = FALSE,
  na_col = "white",
  doPlot = TRUE,
  ...
)
}
\arguments{
\item{x}{A \code{\link[SummarizedExperiment]{SummarizedExperiment}} with
numerical matrices (motifs-by-bins) in its \code{assays()}, typically
the return value of \code{\link{calcBinnedMotifEnrR}} or
\code{\link{calcBinnedMotifEnrHomer}}.}

\item{which.plots}{Selects which heatmaps to plot (one or several from
\code{"negLog10P"}, \code{"negLog10Padj"}, \code{"pearsonResid"} and
\code{"log2enr"}).}

\item{width}{The width (in inches) of each individual heatmap, without
legend.}

\item{col.enr}{Colors used for enrichment heatmap ("pearsonResid" and
"log2enr").}

\item{col.sig}{Colors used for significance hetmaps ("negLog10P" and
"negLog10Padj").}

\item{col.gc}{Colors used for motif GC content (for
\code{show_motif_GC = TRUE}).}

\item{maxEnr}{Cap color mapping at enrichment = \code{maxEnr}
(default: 99.5th percentile).}

\item{maxSig}{Cap color mapping at -log10 P value or -log10 FDR =
\code{maxSig} (default: 99.5th percentile).}

\item{highlight}{A logical vector indicating motifs to be highlighted.}

\item{cluster}{If \code{TRUE}, the order of transcription factors will be
determined by hierarchical clustering of the \code{"pearsonResid"}
component. Alternatively, an \code{hclust}-object can be supplied which
will determine the motif ordering.
No reordering is done for \code{cluster = FALSE}.}

\item{show_dendrogram}{If \code{cluster != FALSE}, controls whether to show
a row dendrogram for the clustering of motifs. Ignored for
\code{cluster = FALSE}.}

\item{show_motif_GC}{If \code{TRUE}, show a column with the percent G+C of
the motif as part of the heatmap.}

\item{show_seqlogo}{If \code{TRUE}, show a sequence logo next to each motif
label. This will likely only make sense for a heatmap with a low number
of motifs.}

\item{show_bin_legend}{If \code{TRUE}, show a legend for the bin labels.
If FALSE (default), the bin legend will be hidden.}

\item{width.seqlogo}{The width (in inches) for the longest sequence logo
(shorter logos are drawn to scale).}

\item{use_raster}{\code{TRUE} or \code{FALSE} (default). Passed to
\code{use_raster} of \code{\link[ComplexHeatmap]{Heatmap}}.}

\item{na_col}{"white" (default). Passed to \code{na_col} of
\code{\link[ComplexHeatmap]{Heatmap}}.}

\item{doPlot}{If \code{TRUE} (default), plot the generated heatmap(s)
using \code{Reduce(ComplexHeatmap::add_heatmap, heatmapList)}. If
\code{FALSE}, just return the list of heatmap(s) (\code{heatmapList}) in
example before), allowing to modify them further before plotting.}

\item{...}{Further arguments passed to \code{\link[ComplexHeatmap]{Heatmap}}
when creating the main heatmaps selected by \code{which.plots}. For
example, the following will set the font size of the motif names:
\code{plotMotifHeatmaps(..., row_names_gp = gpar(fontsize = 12))}}
}
\value{
A list of \code{ComplexHeatmap::Heatmap} objects.
}
\description{
Plot motif enrichments (e.g. significance or magnitude) as a
    heatmap.
}
\details{
The heatmaps are created using the \pkg{ComplexHeatmap} package
    and plotted side-by-side.

    Each heatmap will be \code{width} inches wide, so the total plot needs a
    graphics device with a width of at least
    \code{length(which.plots) * width} plus the space used for motif names
    and legend. The height will be auto-adjusted to the graphics device.
}
\examples{
se <- readRDS(system.file("extdata",
                          "results.binned_motif_enrichment_LMRs.rds",
                          package = "monaLisa"))
i <- which(SummarizedExperiment::assay(se, "negLog10Padj")[, 8] > 4)
plotMotifHeatmaps(se[i, ], which.plots = "pearsonResid",
                  width = 2, show_seqlogo = TRUE)

}
\references{
Gu, Z. Complex heatmaps reveal patterns and correlations in
    multidimensional genomic data. Bioinformatics 2016.
}
\seealso{
\code{\link{bin}}, \code{\link[ComplexHeatmap]{Heatmap}}
}
