% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RNAmergeAnnotations.R
\name{RNAmergeAnnotations}
\alias{RNAmergeAnnotations}
\title{Merge two genome annotation files (GFF Format)}
\usage{
RNAmergeAnnotations(
  annotationA,
  annotationB,
  output_file,
  AnnoA.ID = "A",
  AnnoB.ID = "B",
  format = "gff3"
)
}
\arguments{
\item{annotationA}{path; path to a genome annotation assembly file in GFF format.}

\item{annotationB}{path; path to a genome annotation assembly file in GFF format.}

\item{output_file}{path; a character string or a \code{base::connections()}
open for writing. Including file output name, and must have a GFF file
extension.}

\item{AnnoA.ID}{character; string to represent prefix added to
existing chromosome names in \code{annotationA}. Default set as "A".}

\item{AnnoB.ID}{character; string to represent prefix added to
existing chromosome names in \code{annotationB}. Default set as "B".}

\item{format}{format of GFF output, either "gff", "gff1", "gff2", "gff3."
Default is "gff3".}
}
\value{
A GFF format file containing the annotations of two genomes distinguishable by
the appended prefixes.
}
\description{
Merges two genomes annotation files (GFF) into one
single GFF format file saved to the desired directory. This function adds a
unique prefix to the chromosome names in each genome annotation to ensure
each is distinguishable within the merged file.
}
\details{
As default, the function removes periods and adds a prefix to the existing
chromosome names. The prefix is separated from the original chromosome name
by an underscore. For example, based on the default settings, it will add the
prefix "A_" to the chromosome names in \code{annotationA}, for instance,
A_0, A_1, A_2 etc.

The merged genome is saved to the specified output directory, and requires
the user to set the name with a GFF format.

\strong{IMPORTANT:} The genome reference and annotation of a species
must have chromosomes with matching names. It is critical that if you used
the \code{\link[=RNAmergeGenomes]{RNAmergeGenomes()}} function to create a merged reference
genome,that you treat the input annotations in the same way.
}
\examples{

anno1 <- system.file("extdata", "reduced_chr12_Eggplant.gff.gz",
package="mobileRNA")

anno2 <- system.file("extdata","reduced_chr2_Tomato.gff.gz",
package="mobileRNA")

output_file <- tempfile("merged_annotation", fileext = ".gff3")

merged_anno <- RNAmergeAnnotations(annotationA = anno1, annotationB = anno2,
                                   output_file = output_file)

}
