% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnems.r
\name{simData}
\alias{simData}
\title{Simulate data.}
\usage{
simData(
  Sgenes = 5,
  Egenes = 1,
  Nems = 2,
  reps = NULL,
  mw = NULL,
  evolution = FALSE,
  nCells = 1000,
  uninform = 0,
  unitheta = FALSE,
  edgeprob = c(0, 1),
  multi = FALSE,
  subsample = 1,
  scalefree = FALSE,
  badCells = 0,
  exactProb = TRUE,
  tree = FALSE,
  ...
)
}
\arguments{
\item{Sgenes}{number of Sgenes}

\item{Egenes}{number of Egenes}

\item{Nems}{number of components}

\item{reps}{number of replicates, if set (not realistic for cells)}

\item{mw}{mixture weights (has to be vector of length Nems)}

\item{evolution}{evolving and not purely random network, if set to TRUE}

\item{nCells}{number of cells}

\item{uninform}{number of uninformative Egenes}

\item{unitheta}{uniform theta, if TRUE}

\item{edgeprob}{edge probability, value between 0 and 1 for sparse or
dense networks or a range c(l,u) with lower and upper bound}

\item{multi}{a vector with the percentages of cell with multiple
perturbations, e.g. c(0.2,0.1,0) for 20% double and 10% triple and
no quadruple knock-downs}

\item{subsample}{range to subsample data. 1 means the full simulated data is
used}

\item{scalefree}{if TRUE, graph is scale free}

\item{badCells}{number of cells, which are just noise and not connected
to the ground truth network}

\item{exactProb}{logical; if TRUE generates random network with exact
fraction of edges provided by edgeprob}

\item{tree}{if TRUE, restricts dag to a tree}

\item{...}{additional parameters for the scale free network
sampler (see 'nem' package)}
}
\value{
simulation object with meta information and data
\item{Nem}{list of adjacency matrixes generatign the data}
\item{theta}{E-gene attachaments}
\item{data}{data matrix}
\item{index}{index for which Nem generated which cell
(data column)}
\item{mw}{vector of input mixture weights}
}
\description{
This function simulates single cell data from a random
mixture of networks.
}
\examples{
sim <- simData(Sgenes = 3, Egenes = 2, Nems = 2, mw = c(0.4,0.6))
}
\author{
Martin Pirkl
}
