% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnems.r
\name{plotConvergence}
\alias{plotConvergence}
\title{Plot convergence of EM}
\usage{
plotConvergence(x, ...)
}
\arguments{
\item{x}{object with convergence statistics}

\item{...}{additional parameters for the specific object type}
}
\value{
plot of EM convergence
}
\description{
Generic function plotting convergence diagnostics for different methods.
}
\examples{
sim <- simData(Sgenes = 3, Egenes = 2, Nems = 2, mw = c(0.4,0.6))
data <- (sim$data - 0.5)/0.5
data <- data + rnorm(length(data), 0, 1)
result <- mnem(data, k = 2, starts = 1)
par(mfrow=c(2,2))
plotConvergence(result)
}
\author{
Martin Pirkl
}
