% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnems.r
\name{mnemk}
\alias{mnemk}
\title{Learn the number of components K and optimize the mixture.}
\usage{
mnemk(
  D,
  ks = seq_len(5),
  man = FALSE,
  degree = 4,
  logtype = 2,
  pen = 2,
  useF = FALSE,
  Fnorm = FALSE,
  ...
)
}
\arguments{
\item{D}{data with cells indexing the columns and features (E-genes)
indexing the rows}

\item{ks}{vector of number of components k to test}

\item{man}{logical. manual data penalty, e.g. man=TRUE and pen=2 for an
approximation of the Akaike Information Criterion}

\item{degree}{different degree of penalty for complexity: positive entries
of transitively reduced phis or phi^r (degree=0), phi^r and mixture
components minus one k-1 (1), phi^r, k-1 and positive entries of thetas (2),
positive entries of transitively closed phis or phi^t, k-1 (3), phi^t, theta,
k-1 (4, default), all entries of phis, thetas and k-1 (5)}

\item{logtype}{logarithm type of the data (e.g. 2 for log2 data or exp(1)
for natural)}

\item{pen}{penalty weight for the data (e.g. pen=2 for approximate Akaike
Information Criterion)}

\item{useF}{use F (see publication) as complexity instead of phi and theta}

\item{Fnorm}{normalize complexity of F, i.e. if two components have the
same entry in F, it is only counted once}

\item{...}{additional parameters for the mnem main function}
}
\value{
list containing the result of the best k as an mnem object and the
raw and penalized log likelihoods
}
\description{
High level function for learning the number of components k, if unknown.
}
\examples{
sim <- simData(Sgenes = 3, Egenes = 2, Nems = 2, mw = c(0.4,0.6))
data <- (sim$data - 0.5)/0.5
data <- data + rnorm(length(data), 0, 1)
result <- mnemk(data, ks = seq_len(2), starts = 1)
}
\author{
Martin Pirkl
}
