% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnems.r
\name{mnemh}
\alias{mnemh}
\title{Hierarchical mixture.}
\usage{
mnemh(data, k = 2, logtype = 2, getprobspars = list(), ...)
}
\arguments{
\item{data}{data matrix either binary or log odds}

\item{k}{number of maximal components for each hierarchy leaf}

\item{logtype}{log type of the data}

\item{getprobspars}{list of parameters for the getProbs function}

\item{...}{additional parameters for the mnem function}
}
\value{
object of class mnem
}
\description{
This function does a hierarchical mixture. That means it uses the
approximate BIC to check, if there are more than one component. It
recursively splits the data if there is evidence for k > 1 components.
}
\examples{
sim <- simData(Sgenes = 3, Egenes = 2, Nems = 2, mw = c(0.4,0.6))
data <- (sim$data - 0.5)/0.5
data <- data + rnorm(length(data), 0, 1)
result <- mnemh(data, starts = 1, k = 1)
}
\author{
Martin Pirkl
}
