% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3methods-plot.R
\name{plot.rcc}
\alias{plot.rcc}
\title{Canonical Correlations Plot}
\usage{
\method{plot}{rcc}(x, type = "barplot", ...)
}
\arguments{
\item{x}{object of class inheriting from \code{"rcc"}.}

\item{type}{Character, default "barplot" or any other type available in plot, as "l","b","p",..}

\item{...}{Not used}
}
\value{
none
}
\description{
This function provides scree plot of the canonical correlations.
}
\examples{
data(nutrimouse)
X <- nutrimouse$lipid
Y <- nutrimouse$gene
nutri.res <- rcc(X, Y, lambda1 = 0.064, lambda2 = 0.008)

## 'pointplot' type scree
plot(nutri.res, type = "point") #(default)

\dontrun{
plot(nutri.res, type = "point", pch = 19, cex = 1.2,
col = c(rep("red", 3), rep("darkblue", 18)))

## 'barplot' type scree
plot(nutri.res, type = "barplot")

plot(nutri.res, type = "barplot", density = 20, col = "black")
}

}
\seealso{
\code{\link{points}}, \code{\link{barplot}}, \code{\link{par}}.
}
\author{
Sébastien Déjean, Ignacio González, Al J Abadi
}
\keyword{hplot}
\keyword{multivariate}
