# Exported methods -------------------------------------------------------------

setMethod(
    "bumphunter",
    signature(object = "GenomicRatioSet"),
    function(object, design, cluster = NULL, coef = 2, cutoff = NULL,
             pickCutoff = FALSE, pickCutoffQ = 0.99, maxGap = 500,
             nullMethod = c("permutation", "bootstrap"), smooth = FALSE,
             smoothFunction = locfitByCluster, useWeights = FALSE,
             B = ncol(permutations), permutations = NULL, verbose = TRUE,
             type = c("Beta","M"), ...) {

        .isMatrixBackedOrStop(object, "bumphunter")

        type <- match.arg(type)
        bumphunterEngine(
            mat = getMethSignal(object, type),
            design = design,
            chr = as.factor(seqnames(object)),
            pos = start(object),
            cluster = cluster,
            coef = coef,
            cutoff = cutoff,
            pickCutoff = pickCutoff,
            pickCutoffQ = pickCutoffQ,
            maxGap = maxGap,
            nullMethod = nullMethod,
            smooth = smooth,
            smoothFunction = smoothFunction,
            useWeights = useWeights,
            B = B,
            permutations = permutations,
            verbose = verbose,
            ...)
    }
)
