% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotNhoods.R
\name{plotNhoodCounts}
\alias{plotNhoodCounts}
\title{Plot the number of cells in a neighbourhood per sample and condition}
\usage{
plotNhoodCounts(x, subset.nhoods, design.df, condition, n_col = 3)
}
\arguments{
\item{x}{A \code{\linkS4class{Milo}} object with a non-empty \code{nhoodCounts}
slot.}

\item{subset.nhoods}{A logical, integer or character vector indicating the rows of \code{nhoodCounts(x)} to use for
plotting. If you use a logical vector, make sure the length matches \code{nrow(nhoodCounts(x))}.}

\item{design.df}{A \code{data.frame} which matches samples to a condition of interest.
The row names should correspond to the samples. You can use the same \code{design.df}
that you already used in the \code{testNhoods} function.}

\item{condition}{String specifying the condition of interest Has to be a column in the \code{design}.}

\item{n_col}{Number of columns in the output \code{ggplot}.}
}
\value{
A \code{ggplot-class} object
}
\description{
Plot the number of cells in a neighbourhood per sample and condition
}
\examples{

require(SingleCellExperiment)
ux.1 <- matrix(rpois(12000, 5), ncol=300)
ux.2 <- matrix(rpois(12000, 4), ncol=300)
ux <- rbind(ux.1, ux.2)
vx <- log2(ux + 1)
pca <- prcomp(t(vx))

sce <- SingleCellExperiment(assays=list(counts=ux, logcounts=vx),
                            reducedDims=SimpleList(PCA=pca$x))
milo <- Milo(sce)
milo <- buildGraph(milo, k=20, d=10, transposed=TRUE)
milo <- makeNhoods(milo, k=20, d=10, prop=0.3)
milo <- calcNhoodDistance(milo, d=10)

cond <- sample(c("A","B","C"),300,replace=TRUE)

meta.df <- data.frame(Condition=cond, Replicate=c(rep("R1", 100), rep("R2", 100), rep("R3", 100)))
meta.df$SampID <- paste(meta.df$Condition, meta.df$Replicate, sep="_")
milo <- countCells(milo, meta.data=meta.df, samples="SampID")

design.mtx <- data.frame("Condition"=c(rep("A", 3), rep("B", 3), rep("C",3)),
                         "Replicate"=rep(c("R1", "R2", "R3"), 3))
design.mtx$SampID <- paste(design.mtx$Condition, design.mtx$Replicate, sep="_")
rownames(design.mtx) <- design.mtx$SampID

plotNhoodCounts(x = milo,
                subset.nhoods = c(1,2),
                design.df = design.mtx,
                condition = "Condition")

}
\author{
Nick Hirschmüller
}
