% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmm.R
\name{initialiseG}
\alias{initialiseG}
\title{Construct the initial G matrix}
\usage{
initialiseG(cluster_levels, sigmas, Kin = NULL)
}
\arguments{
\item{cluster_levels}{A \code{list} containing the random effect levels for each variable}

\item{sigmas}{A \code{matrix} of c X 1, i.e. a column vector, containing the variance component estimates}

\item{Kin}{A \code{matrix} containing a user-supplied covariance matrix}
}
\value{
\code{matrix} of the full broadcast variance component estimates.
}
\description{
This function maps the variance estimates onto the full \code{c x q} levels for each random effect. This
ensures that the matrices commute in the NB-GLMM solver. This function is included for reference, and
should not be used directly
}
\details{
Broadcast the variance component estimates to the full \code{c\*q x c\*q} matrix.
}
\examples{
data(sim_nbglmm)
random.levels <- list("RE1"=paste("RE1", levels(as.factor(sim_nbglmm$RE1)), sep="_"),
                      "RE2"=paste("RE2", levels(as.factor(sim_nbglmm$RE2)), sep="_"))
rand.sigma <- matrix(runif(2), ncol=1)
rownames(rand.sigma) <- names(random.levels)
big.G <- initialiseG(random.levels, rand.sigma)
dim(big.G)

}
\author{
Mike Morgan & Alice Kluzer
}
