% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmm.R
\name{computePvalue}
\alias{computePvalue}
\title{Compute the p-value for the fixed effect parameters}
\usage{
computePvalue(Zscore, df)
}
\arguments{
\item{Zscore}{A numeric vector containing the Z scores for each fixed effect parameter}

\item{df}{A numeric vector containing the estimated degrees of freedom for each fixed effect
parameter}
}
\value{
Numeric vector of p-values, 1 per fixed effect parameter
}
\description{
Based on the asymptotic t-distribution, comptue the 2-tailed p-value that estimate != 0. This
function is not intended to be used directly, but is included for reference or if an alternative
estimate of the degrees of freedom is available.
}
\details{
Based on sampling from a 2-tailed t-distribution with \code{df} degrees of freedom,
compute the probability that the calculated \code{Zscore} is greater than or equal to what would be
expected from random chance.
}
\examples{
NULL

}
\author{
Mike Morgan & Alice Kluzer
}
