% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{LRTest}
\alias{LRTest}
\title{Likelihood ratio test}
\usage{
LRTest(mod0, mod1)
}
\arguments{
\item{mod0}{An existing fit from a model function such as lm, glm and many
others.}

\item{mod1}{Object of the same class as \code{mod0} with extra terms
included.}
}
\value{
Data frame with the results of likelihood ratio test of the supplied
  models.

  Column \code{term} holds new variables appearing in \code{mod1},
  \code{df} difference in degrees of freedom between models, \code{logLik}
  difference in log likelihoods, \code{statistic} \code{Chisq} statistic and
  \code{p.value} corresponding p-value.
}
\description{
\code{LRTest} carry out an asymptotic likelihood ratio test for two models.
}
\details{
\code{mod0} have to be a reduced version of \code{mod1}. See examples.
}
