% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/richness.R
\name{richness}
\alias{richness}
\title{Richness Index}
\usage{
richness(x, index = c("observed", "chao1"), detection = 0)
}
\arguments{
\item{x}{A species abundance vector, or matrix (taxa/features x samples)
with the absolute count data (no relative abundances), or
\code{\link{phyloseq-class}} object}

\item{index}{"observed" or "chao1"}

\item{detection}{Detection threshold. Used for the "observed" index.}
}
\value{
A vector of richness indices
}
\description{
Community richness index.
}
\details{
By default, returns the richness for multiple detection thresholds
defined by the data quantiles. If the detection argument is provided,
returns richness with that detection threshold. The "observed" richness
corresponds to index="observed", detection=0.
}
\examples{
data(dietswap)
d <- richness(dietswap, detection=0)
}
\seealso{
alpha
}
\author{
Contact: Leo Lahti \email{microbiome-admin@googlegroups.com}
}
\keyword{utilities}
