% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_age.R
\name{group_age}
\alias{group_age}
\title{Age Classes}
\usage{
group_age(
  x,
  breaks = "decades",
  n = 10,
  labels = NULL,
  include.lowest = TRUE,
  right = FALSE,
  dig.lab = 3,
  ordered_result = FALSE
)
}
\arguments{
\item{x}{Numeric vector (age in years)}

\item{breaks}{Class break points. Either a vector of breakpoints,
or one of the predefined options ("years", "decades", "even").}

\item{n}{Number of groups for the breaks = "even" option.}

\item{labels}{labels for the levels of the resulting category.  By default,
    labels are constructed using \code{"(a,b]"} interval notation.  If
    \code{labels = FALSE}, simple integer codes are returned instead of
    a factor.}

\item{include.lowest}{logical, indicating if an \sQuote{x[i]} equal to
    the lowest (or highest, for \code{right = FALSE}) \sQuote{breaks}
    value should be included.}

\item{right}{logical, indicating if the intervals should be closed on
    the right (and open on the left) or vice versa.}

\item{dig.lab}{integer which is used when labels are not given.  It
    determines the number of digits used in formatting the break numbers.}

\item{ordered_result}{logical: should the result be an ordered factor?}
}
\value{
Factor of age groups.
}
\description{
Cut age information to discrete factors.
}
\details{
Regarding the breaks arguments, the "even" option aims to
cut the samples in groups with approximately the same size (by
quantiles). The "years" and "decades" options are self-explanatory.
}
\examples{
data(atlas1006)
age.numeric <- meta(atlas1006)$age
age.factor <- group_age(age.numeric)
}
\references{
See citation('microbiome')
}
\seealso{
base::cut
}
\author{
Contact: Leo Lahti \email{microbiome-admin@googlegroups.com}
}
\keyword{utilities}
