% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_core.R
\name{core_matrix}
\alias{core_matrix}
\title{Core Matrix}
\usage{
core_matrix(x, prevalences = seq(0.1, 1, , 1), detections = NULL)
}
\arguments{
\item{x}{\code{\link{phyloseq}} object or a taxa x samples abundance matrix}

\item{prevalences}{a vector of prevalence percentages in [0,1]}

\item{detections}{a vector of intensities around the data range}
}
\value{
Estimated core microbiota
}
\description{
Creates the core matrix.
}
\examples{
# Not exported
#data(peerj32)
#core <- core_matrix(peerj32$phyloseq)
}
\references{
A Salonen et al. The adult intestinal core microbiota is determined by 
analysis depth and health status. Clinical Microbiology and Infection 
18(S4):16 20, 2012. 
To cite the microbiome R package, see citation('microbiome')
}
\author{
Contact: Jarkko Salojarvi \email{microbiome-admin@googlegroups.com}
}
\keyword{utilities}
