% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collapse_replicates.R
\name{collapse_replicates}
\alias{collapse_replicates}
\title{Collapse Replicate Samples}
\usage{
collapse_replicates(
  x,
  method = "sample",
  replicate_id = NULL,
  replicate_fields = NULL
)
}
\arguments{
\item{x}{\code{\link{phyloseq-class}} object}

\item{method}{Collapsing method. Only random sampling ("sample") implemented.}

\item{replicate_id}{Replicate identifier. A character vector.}

\item{replicate_fields}{Metadata fields used to determine replicates.}
}
\value{
Collapsed phyloseq object.
}
\description{
Collapse samples, mostly meant for technical replicates.
}
\examples{
data(atlas1006)
pseq <- collapse_replicates(atlas1006,
        method = "sample",
        replicate_fields = c("subject", "time"))
}
\references{
To cite the microbiome R package, see citation('microbiome')
}
\author{
Contact: Leo Lahti \email{microbiome-admin@googlegroups.com}
}
\keyword{utilities}
