% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importMothur.R
\name{importMothur}
\alias{importMothur}
\title{Import Mothur results as a \code{TreeSummarizedExperiment}}
\usage{
importMothur(
  assay.file = sharedFile,
  sharedFile,
  taxonomyFile = NULL,
  row.file = taxonomyFile,
  designFile = NULL,
  col.file = designFile
)
}
\arguments{
\item{assay.file}{\code{Character scalar}. Defines the file
path of the feature table to be imported. The File has to be in
\code{shared file} format as defined in Mothur documentation.}

\item{sharedFile}{Deprecated. Use \code{assay.file} instead.}

\item{taxonomyFile}{Deprecated. Use \code{row.file} instead.}

\item{row.file}{\code{Character scalar}. Defines the file path of
the taxonomy table to be imported. The File has to be in \code{taxonomy
  file} or \code{constaxonomy file} format  as defined in Mothur
documentation. (Default: \code{NULL}).}

\item{designFile}{Deprecated. Use \code{col.file} instead.}

\item{col.file}{\code{Character scalar}. Defines file path of
the sample metadata to be imported. The File has to be in \code{design
  file} format as defined in Mothur documentation. (Default: \code{NULL}).}
}
\value{
A
\code{\link[TreeSummarizedExperiment:TreeSummarizedExperiment-class]{TreeSummarizedExperiment}}
object
}
\description{
This method creates a \code{TreeSummarizedExperiment} object from
\code{Mothur} files provided as input.
}
\details{
Results exported from Mothur can be imported as a
\code{SummarizedExperiment} using \code{importMothur}. Except for the
\code{assay.file}, the other data types, \code{row.file}, and
\code{col.file}, are optional, but are highly encouraged to be provided.
}
\examples{
# Abundance table
counts <- system.file("extdata", "mothur_example.shared", package = "mia")
# Taxa table (in "cons.taxonomy" or "taxonomy" format)
taxa <- system.file(
    "extdata", "mothur_example.cons.taxonomy", package = "mia")
#taxa <- system.file("extdata", "mothur_example.taxonomy", package = "mia")
# Sample meta data
meta <- system.file("extdata", "mothur_example.design", package = "mia")

# Creates se object from files
se <- importMothur(assay.file = counts, row.file = taxa, col.file = meta)
# Convert SE to TreeSE
tse <- as(se, "TreeSummarizedExperiment")
tse
}
\references{
\url{https://mothur.org/}
\url{https://mothur.org/wiki/shared_file/}
\url{https://mothur.org/wiki/taxonomy_file/}
\url{https://mothur.org/wiki/constaxonomy_file/}
\url{https://mothur.org/wiki/design_file/}
}
\seealso{
\code{\link[=convertFromPhyloseq]{convertFromPhyloseq}}
\code{\link[=convertFromBIOM]{convertFromBIOM}}
\code{\link[=convertFromDADA2]{convertFromDADA2}}
\code{\link[=importQIIME2]{importQIIME2}}
}
