% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miRSM.R
\name{module_biclust}
\alias{module_biclust}
\title{module_biclust}
\usage{
module_biclust(
  ceRExp,
  mRExp = NULL,
  BCmethod = "fabia",
  num.modules = 10,
  num.ModuleceRs = 2,
  num.ModulemRs = 2
)
}
\arguments{
\item{ceRExp}{A SummarizedExperiment object. ceRNA expression data: 
rows are samples and columns are ceRNAs.}

\item{mRExp}{NULL (default) or a SummarizedExperiment object. mRNA expression data: 
rows are samples and columns are mRNAs.}

\item{BCmethod}{Specification of the biclustering method, 
including 'BCBimax', 'BCCC', 'BCPlaid' (default), 'BCQuest', 
'BCSpectral', 'BCXmotifs', iBBiG', 'fabia', 'fabiap', 
'fabias', 'mfsc', 'nmfdiv', 'nmfeu', 'nmfsc', 'FLOC', 'isa', 
'BCs4vd', 'BCssvd', 'bibit' and 'quBicluster'.}

\item{num.modules}{The number of modules to be identified. For the 'BCPlaid',
'BCSpectral', 'isa' and 'bibit' methods, no need to set the parameter. For the 
'quBicluster' method, the parameter is used to set the number of biclusters 
that should be reported.}

\item{num.ModuleceRs}{The minimum number of ceRNAs in each module.}

\item{num.ModulemRs}{The minimum number of mRNAs in each module.}
}
\value{
GeneSetCollection object: a list of module genes.
}
\description{
Identification of gene modules from matched ceRNA and mRNA 
expression data or single gene expression data using a series  
of biclustering packages, including biclust, iBBiG, fabia,  
BicARE, isa2, s4vd, BiBitR and rqubic
}
\examples{
data(BRCASampleData)
modulegenes_biclust <- module_biclust(ceRExp[, seq_len(30)],
    mRExp[, seq_len(30)])

}
\references{
Preli\'{c} A, Bleuler S, Zimmermann P, Wille A, 
B\'{u}hlmann P, Gruissem W, Hennig L, Thiele L, Zitzler E. 
A systematic comparison and evaluation of biclustering methods 
for gene expression data. Bioinformatics. 2006, 22(9):1122-9.

Cheng Y, Church GM. Biclustering of expression data. 
Proc Int Conf Intell Syst Mol Biol. 2000, 8:93-103.

Turner H, Bailey T, Krzanowski W. Improved 
biclustering of microarray data demonstrated through systematic 
performance tests. Comput Stat Data Anal. 2003, 48(2): 235-254.

Murali TM, Kasif S. Extracting conserved gene 
expression motifs from gene expression data. 
Pac Symp Biocomput. 2003:77-88.

Kluger Y, Basri R, Chang JT, Gerstein M. 
Spectral biclustering of microarray data: coclustering genes 
and conditions. Genome Res. 2003, 13(4):703-16.

Gusenleitner D, Howe EA, Bentink S, Quackenbush J, 
Culhane AC. iBBiG: iterative binary bi-clustering of gene sets. 
Bioinformatics. 2012, 28(19):2484-92.

Hochreiter S, Bodenhofer U, Heusel M, Mayr A, 
Mitterecker A, Kasim A, Khamiakova T, Van Sanden S, Lin D, 
Talloen W, Bijnens L, G\'{o}hlmann HW, Shkedy Z, Clevert DA. 
FABIA: factor analysis for bicluster acquisition. 
Bioinformatics. 2010, 26(12):1520-7.

Yang J, Wang H, Wang W, Yu, PS. An improved 
biclustering method for analyzing gene expression. 
Int J Artif Intell Tools. 2005, 14(5): 771-789.

Bergmann S, Ihmels J, Barkai N. Iterative 
signature algorithm for the analysis of large-scale gene 
expression data. Phys Rev E Stat Nonlin Soft Matter Phys. 
2003, 67(3 Pt 1):031902.

Sill M, Kaiser S, Benner A, Kopp-Schneider A. 
Robust biclustering by sparse singular value decomposition 
incorporating stability selection. Bioinformatics. 2011, 
27(15):2089-97.

Lee M, Shen H, Huang JZ, Marron JS. Biclustering 
via sparse singular value decomposition. Biometrics. 2010, 
66(4):1087-95.

Rodriguez-Baena DS, Perez-Pulido AJ, Aguilar-Ruiz JS. 
A biclustering algorithm for extracting bit-patterns from 
binary datasets. Bioinformatics. 2011, 27(19):2738-45.

Li G, Ma Q, Tang H, Paterson AH, Xu Y. 
QUBIC: a qualitative biclustering algorithm for analyses of 
gene expression data. Nucleic Acids Res. 2009, 37(15):e101.
}
\author{
Junpeng Zhang (\url{https://www.researchgate.net/profile/Junpeng-Zhang-2})
}
